 aR  w Q m^9      h	 oP       nSystem-wide
        NAME  Intrcept_Patch


PUBLIC MsReplaceInterrupts, MsExitBackground
PUBLIC MsRestoreInterrupts
PUBLIC lastDataWord, lastCodeWord, lastConstant
PUBLIC inside

EXTRN PLMInterrupt21:NEAR, PLMOuterrupt21:NEAR, MsDos:NEAR
EXTRN SysDepPatchCalls:NEAR, SysDepUnPatchCalls:NEAR

; External variables in CS

EXTRN patched:BYTE
EXTRN msDosIntOffset:WORD, msDosIntSegment:WORD

; External variables in DS

EXTRN oldTimerOff:WORD, timerIntSegAddr:WORD
EXTRN calledDevice:BYTE, devIntrError:BYTE, deviceError:WORD


FALSE           EQU 0
TRUE            EQU 1

oldExitCmd      EQU 00H
createPdbCmd    EQU 26H
loadAndGoCmd    EQU 4BH

eUnlinkFailed   EQU 1250

msDosIntSegAddr EQU 084H     ; 21H * 4
cpmJumpSegAddr  EQU 0C1H

CGROUP   GROUP CODE, LCODE
DGROUP   GROUP DATA, LDATA
IGROUP   GROUP CONST

CODE    SEGMENT  PUBLIC 'CODE'
ASSUME  CS:CGROUP, DS:DGROUP
$EJECT

;==================================================
;
;  MsReplaceInterrupts: PROCEDURE CLEAN;
;
;==================================================
      
MsReplaceInterrupts PROC NEAR

    PUSHF
    CLI

    PUSH DS                     ; Save DS

    CALL SysDepPatchCalls

    XOR  AX, AX
    MOV  DS, AX                 ; Interrupt Vectors

    MOV  SI, cpmJumpSegAddr     ; CP/M Long Jump
    LES  BX, DWORD PTR DS:[SI]

    MOV  CS:oldCpmJmpOff, BX
    MOV  CS:oldCpmJmpSeg, ES    ; Save old CP/M Jump

    MOV  DS:[SI+0], OFFSET Cpm
    MOV  DS:[SI+2], CS          ; Set new CP/M Jump

    MOV  SI, msDosIntSegAddr    ; MsDOS Interrupt
    LES  BX, DWORD PTR DS:[SI]

    MOV  CS:oldInt21Off,  BX
    MOV  CS:oldInt21Seg,  ES    ; Save old MsDos Entry

    MOV  DS:[SI+0], OFFSET Int21
    MOV  DS:[SI+2], CS          ; Set new MsDos Entry

    POP  DS                     ; Restore DS

    MOV  CS:intrStackSP, OFFSET stackTop
    MOV  CS:intrStackSS, DS     ; Initialize stack

    MOV  CS:msDosIntOffset,  BX ; This is for the
    MOV  CS:msDosIntSegment, ES ; MsCalls module -
    MOV  CS:patched, TRUE       ; avoids ^C problem

    POPF
    RET
MsReplaceInterrupts ENDP
$EJECT

;==================================================
;
;  MsRestoreInterrupts: PROCEDURE (pError) PTR CLEAN;
;
;==================================================

; This routine uses registers (most of the time)
; in the following ways:

; AX => Code seg of this program
; DX => Error code
; DS => Segment of interrupts (i.e. 0)
; SI => Addr of timer interrupt
; DI => Addr of MsDos interrupt
; BX => Addr of Cp/M Jump addr
; ES:CX => Temporary to hold old addresses

pError EQU DWORD PTR [BP+4]
      
MsRestoreInterrupts PROC NEAR

    PUSH BP
    MOV  BP, SP
    PUSH DS
    PUSHF
    CLI

    MOV  SI, DS:timerIntSegAddr ; Timer Interrupt
    MOV  DI, msDosIntSegAddr    ; MsDOS Interrupt
    MOV  BX, cpmJumpSegAddr     ; CP/M Long Jump

	   XOR  AX, AX
    MOV  DS, AX                 ; Interrupt Vectors

    MOV  AX, CS                 ; AX => code seg
    MOV  DX, eUnlinkFailed      ; Assume the worse

    CMP  AX, WORD PTR DS:[SI+2]
    JNE  MsRestoreInterruptsExit

    CMP  AX, WORD PTR DS:[DI+2]
    JNE  MsRestoreInterruptsExit

    CMP  AX, WORD PTR DS:[BX+2]
    JNE  MsRestoreInterruptsExit

    CALL SysDepUnPatchCalls
    JC   MsRestoreInterruptsExit

    LES  CX, DWORD PTR CS:oldTimerOff
    MOV  DS:[SI+0], CX
    MOV  DS:[SI+2], ES          ; Restore Timer Entry

    LES  CX, DWORD PTR CS:oldInt21Off
    MOV  DS:[DI+0], CX
    MOV  DS:[DI+2], ES          ; Restore MsDos Entry

    LES  CX, DWORD PTR CS:oldCpmJmpOff
    MOV  DS:[BX+0], CX
    MOV  DS:[BX+2], ES          ; Restore MsDos Entry

    SUB  AX, 10H                ; 256 byte header
    MOV  ES, AX
    XOR  BX, BX

    XOR  DX, DX                 ; Error = eOK

MsRestoreInterruptsExit:
    LDS  SI, pError
    MOV  DS:[SI], DX
    
    POPF
    POP  DS
    POP  BP
    RET  4
MsRestoreInterrupts ENDP

PURGE pError
$EJECT

;==================================================
;
;  MsExitBackground: PROCEDURE CLEAN;
;
;==================================================

MsExitBackground PROC NEAR

    MOV  CL, 4
    XOR  DX, DX

    MOV  AX, OFFSET DGROUP:lastDataWord
    SHR  AX, CL
    ADD  DX, AX

    MOV  AX, OFFSET CGROUP:lastCodeWord
    SHR  AX, CL
    ADD  DX, AX

    MOV  AX, OFFSET lastConstant
    SHR  AX, CL
    ADD  DX, AX

    ADD  DX, 17H   ; For program prefix & fudge

    MOV  AX, 3100H ; Exit w/Keep Process
    INT  21H

;   RET            ; Should never return here

MsExitBackground ENDP
$EJECT

Cpm PROC FAR

    POP  AX                       ; Throw away first IP
    POP  CS:callersCS             ; Save Return CS
    POP  AX                       ; Save Final IP

    PUSHF                         ; Simulate Interrupt
    CLI                           ; Simulate Interrupt
    PUSH CS:callersCS             ; Simulate Interrupt
    PUSH AX                       ; Simulate Interrupt

    CMP  CL, 24H
    JA   CpmInvalidCall

    MOV  AH, CL                   ; Make look like CP/M call
    JMP  SHORT Int21EntryFromCpm

CpmInvalidCall:
    MOV  AL, 0
    IRET                          ; Nope

Cpm ENDP
$EJECT

Int21ExitJump:
    JMP  DWORD PTR CS:oldInt21Off


; This page of code decides what path to take based on the function

Int21 PROC FAR
    CLI                      ; DISABLE

Int21EntryFromCpm:
    CMP  AH, loadAndGoCmd    ; Check for Load & Go
    JE   Int21ExitJump

    CMP  AH, createPdbCmd    ; Check for Create PDB
    JE   Int21ExitJump

Int21AbortExit:
    TEST CS:inside, TRUE
    JNZ  Int21ExitJump

    MOV  CS:callFunction, AH
$EJECT

; This page of code calls Interceptor before the call

    PUSH AX                  ; These registers can be saved on the stack
    PUSH BX                  ; here because at least this much stack space
    PUSH CX                  ; is required by MsDos
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  CS:inside, TRUE
    STI                      ; ENABLE

    PUSH CS:userStackSS
    PUSH CS:userStackSP

    CALL PLMInterrupt21
    MOV  CS:callHost, AL

    CLI                      ; DISABLE
    MOV  CS:inside, FALSE

    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
$EJECT

; This page of code may (may not) call MsDos with the function

    CMP  CS:callFunction, oldExitCmd
    JE   Int21ExitJump

    TEST CS:callHost, TRUE
    JZ   Int21AfterCallHost

    MOV  CS:saveCallBX, BX     ; save BX
    MOV  BX, CS:retInt21Indx   ; current index into circular queue
    POP  CS:retInt21Adrs[BX+0] ; save callers IP
    POP  CS:retInt21Adrs[BX+2] ; save callers CS
    ADD  BX, 4                 ; next save index
    AND  BX, retInt21AdrsMod   ; make it circular
    MOV  CS:retInt21Indx, BX   ; update index
    MOV  BX, CS:saveCallBX     ; restore BX

    CALL DWORD PTR CS:oldInt21Off

    PUSHF                      ; restore stack to look like interrupt
    CLI

    MOV  CS:saveCallBX, BX     ; save BX
    MOV  BX, CS:retInt21Indx   ; current index into circular queue
    SUB  BX, 4                 ; prev save index
    AND  BX, retInt21AdrsMod   ; make it circular
    PUSH CS:retInt21Adrs[BX+2] ; restore callers CS
    PUSH CS:retInt21Adrs[BX+0] ; restore callers IP
    MOV  CS:retInt21Indx, BX   ; update index
    MOV  BX, CS:saveCallBX     ; restore BX
$EJECT

; This page of code calls Interceptor after the call

Int21AfterCallHost:
    PUSH AX                  ; These registers can be saved on the stack
    PUSH BX                  ; here because at least this much stack space
    PUSH CX                  ; is required by MsDos
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  CS:inside, TRUE
    STI                      ; ENABLE

    PUSH CS:userStackSS
    PUSH CS:userStackSP

    CALL PLMOuterrupt21

    CLI                      ; DISABLE
    MOV  CS:inside, FALSE

    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
$EJECT

; This page of code handles device errors and exits

    PUSH ES                  ; These registers can be saved on the stack
    PUSH DS                  ; here because at least this much stack space
    PUSH BP                  ; is required by MsDos
    PUSH DI
    PUSH SI
    PUSH DX
    PUSH CX
    PUSH BX
    PUSH AX

Int21DevErrorLoop:
    MOV  CS:saveDS, DS
    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AL, DS:devIntrError
    MOV  AH, 0
    MOV  DI, AX
    MOV  AL, DS:calledDevice
    MOV  AH, 2
    MOV  BP, SEG    fakeDevTable
    MOV  SI, OFFSET fakeDevTable

    CMP  DS:deviceError, 0
    MOV  DS, CS:saveDS
    JZ   Int21AfterDevError

    INT  24H
    CLI                      ; DISABLE
    CMP  AL, 0
    JE   Int21AfterDevError

    CMP  AL, 1
    JE   Int21DevErrorLoop

    MOV  AX, 4CFFH           ; Exit with return code FFH
    JMP  Int21AbortExit

Int21AfterDevError:
    POP  AX
    POP  BX
    POP  CX
    POP  DX
    POP  SI
    POP  DI
    POP  BP
    POP  DS
    POP  ES
    IRET
Int21 ENDP
$EJECT

fakeDevTable LABEL BYTE
             DW 0FFFFH
             DW 0FFFFH
             DW 0
             DW OFFSET fakeDevRet ; word offset of dev strategy entrypoint
             DW OFFSET fakeDevRet ; word offset of dev interrupt entrypoint
             DW 0ffh

fakeDevRet PROC FAR
    RET
fakeDevRet ENDP


retInt21AdrsMod EQU 31 ; This must be 2x the num of words in retInt21Adrs

inside       DB FALSE
callHost     DB FALSE
callFunction DB ?
wordAlign1   DB ?

oldCpmJmpOff DW ?
oldCpmJmpSeg DW ?

oldInt21Off  DW ?
oldInt21Seg  DW ?

saveDS       DW ?
saveCallBX   DW ?

retInt21Indx DW 0
retInt21Adrs DW 16 DUP (?)

intrStackSS  DW ?
intrStackSP  DW ?

userStackSS  DW ?
userStackSP  DW ?

callersCS    DW ?
retInt21Flag DW ?

CODE    ENDS


CONST   SEGMENT  PUBLIC 'CONST'

lastConstant DW ?

CONST   ENDS


DATA    SEGMENT  PUBLIC 'DATA'

             DW 500 DUP (?)
stackTop     DW ?

DATA    ENDS


LDATA   SEGMENT  PUBLIC 'DATA'

lastDataWord DW ?

LDATA   ENDS


LCODE   SEGMENT  PUBLIC 'CODE'

lastCodeWord DW ?

LCODE   ENDS


        END
